	function [G, Z, P, alfa] = L_PHASE_IIR_HB(WcT, WsT, Amax, Amin, N)
 
	% 	Design of half-band linear-phase IIR filters realized as a parallel
	% 	connection of two allpass filters, one M = (N-1)/2 delays.
	%	The order of the allpass filter is M+1.
	%
	% 	Uses the algorithm of M. Renfors and T. Saramaki, ISCAS 1986.
	
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Hakan Johansson 1996-05-04
	% 	Modified by: 	LW 2010-12-17
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	% Initialization
	points = 10;
	delay = 1; 
	range = points*180;
	ep = 0.00001;
	order = N;
	Wp = points*(180-108); %	passband edge  =  180-stopband edge, in degrees
	N1 = 2; %	Half-band case
	R = (order+1)/4;
	M1 = (order-1)/2;
	wp = Wp*2*pi/(points*360);
	Q = 2;	w = 0;	h = 0;	f = 0;	ftemp = 0;	first = 0;	second = 0;
	
	%	Initial Guess of Frequency Points
	for freqPoint = 1:R,
		w(freqPoint) = (2/N1)*asin(sin(N1*wp/2)*sin(freqPoint*pi/(2*R+1)));
	end
	while abs(Q-1) > ep
		% Calculate the magnitude function
		Psi = -(2*R-delay)*w;
		P = Polynomial(Psi,w,N1,R);
		Z = roots(P);
		[first, second] = extract(Z);
		coeffFirst = CAL_COEFF_FIRST(first);
		coeffSecond = CAL_COEFF_SECOND(second);
		h = LATTICE_HB_H(coeffFirst,coeffSecond,delay,points);
		f = h(180*points-Wp+1:180*points+1);
		% Find the R+1 largest maxima of f
		wl = 0;
		index = 1;
		for n = 1:Wp-1,
			if (f(n+2) <= f(n+1)) & (f(n) <= f(n+1)),
				wl(index) = n+1;
				index = index+1;
			end
		end
		if length(wl) < R+1,
			if f(Wp+1) > f(1),
				wl(R+1) = Wp+1;
			else
				wl(R+1) = 1;
				wl = sort(wl);
			end
		end
		maxInd = 1;
		minInd = 1;
		for k = 2:R+1,
			if(f(wl(k)) > f(wl(maxInd))),
				maxInd = k;
			end
			if(f(wl(k)) < f(wl(minInd))),
				minInd = k;
			end
		end
		Q = f(wl(maxInd))/f(wl(minInd));
		if abs(Q-1) > ep,
			% Calculate partial derivatives
			deltaw = 0.00001;
			FM = 0;
			fM = 0;
			for k = 1:R,
				wtemp = w;
				wtemp(k) = wtemp(k)+deltaw;
				Psi = -(2*R-delay)*wtemp;
				Ptemp = Polynomial(Psi,wtemp,N1,R);
				Ztemp = roots(Ptemp);
				[firstTemp, secondTemp] = extract(Ztemp);
				coeffFirstTemp = CAL_COEFF_FIRST(firstTemp);
				coeffSecondTemp = CAL_COEFF_SECOND(secondTemp);
				htemp = LATTICE_HB_H(coeffFirstTemp,coeffSecondTemp,delay,points);
				ftemp = htemp(180*points-Wp+1:180*points+1);
				for k1 = 1:R+1,
					FM(k1,k) = ftemp(wl(k1))-f(wl(k1));
				end
			end
			FM = FM/deltaw;
			for index = 1:R+1,
				FM(index,R+1) = -1;
				fM(index) = f(wl(index));
			end
			min(abs(FM));
			max(abs(inv(FM)));
			deltaw = -inv(FM)*fM';
			w = w+deltaw(1:R)';
		end
	end

	num = P;	
	den = num;
	len = length(num);
	for n = 2:2:len
		den(len-n+1) = -num(len-n+1);
	end
	[numd dend] = bilinear(num,den,0.5);	 
	X = zeros(order-M1+1,1);
	for n = 1:(order-M1)/2+1
		X(2*n-1) = dend(n);
	end
	Num = [zeros(1,M1),X'] + [fliplr(X'),zeros(1,M1)];
	P1 = sqrt(roots(dend))'; 
	P0 = fliplr(cplxpair(roots(dend))')';
	alfa(1) = P0(1);
	for k = 2:2:length(P0)-1
		alfa(k) = -abs(P0(k))^2;
		alfa(k+1) = real(2*P0(k))/(1-alfa(k));
	end
	P = [zeros(M1,1);[P1 -P1]'];
	Z = roots(Num);
	G = 0.5*Num(1);
	
	%=====================
	function P = Polynomial(Psi,w,N,R)
	
	W = 0;	B = 0;	D = 0;	P = 0;	P1 = 0;	P2 = 0;	P3 = 0;	
	for index = 1:length(w),
		W(index) = tan(N*w(index)/2);
	end

	% Calculate the parameters B	
	B(1) = tan(Psi(1)/2)/W(1);
	if R>1
		B(2) = (1-B(1)*W(2)/tan(Psi(2)/2))/(W(2)*W(2)-W(1)*W(1));
	end
	if R>2,
		for r = 3:R,
			D = tan(Psi(r)/2);
			for k = 1:r-2,
				if k == 1,
					D = 1-B(1)*W(r)/D;
				else
					D = 1-B(k)*(W(r)*W(r)-W(k-1)*W(k-1))/D;
				end
			end
			B(r) = (1-B(r-1)*(W(r)*W(r)-W(r-2)*W(r-2))/D)/(W(r)*W(r)-W(r-1)*W(r-1));
		end
	end

	% Calculate the polynomial P(s)	
	P1 = 1;	P2 = [1 B(1)];
	if R > 1
		for r = 2:R,
			P3 = P2;	P3(length(P2)+1) = 0;
			for index = 1:length(P1)
				P3(index) = P3(index)+B(r)*W(r-1)*W(r-1)*P1(index);
			end
			for index = 3:length(P1)+2,
				P3(index) = P3(index)+B(r)*P1(index-2);
			end
			P1 = P2; P2 = P3;
		end
		for k = 1:length(P3),
			P(length(P3)-k+1) = P3(k);
		end
	else
		P = [B(1) 1];
	end

	% =========================	
	function [first, second] = extract(P)
	% Returns the coefficients from the first-order and second-order 
	% factors of the roots of the polynomial P

	first = 1;	index_f = 1;
	if ~(P(1) == 1),
		for index_p = 1:length(P),
			if imag(P(index_p)) == 0,
				first(index_f) = P(index_p);
				index_f = index_f+1;
			end
		end
	end
	second = 1;	index_s = 1;	index_p = 1;
	if ~(P(1) == 1),
		while index_p <= length(P),
			if ~(imag(P(index_p)) == 0),
				second(index_s) = 2*real(P(index_p));
				second(index_s+1) = real(P(index_p))*real(P(index_p))+imag(P(index_p))*imag(P(index_p));
				index_s = index_s+2;
				index_p = index_p+2;
			else
				index_p = index_p+1;
			end
		end
	end
	% =========================	
